/*
 * Copyright (c) 2013-2019 Huawei Technologies Co., Ltd. All rights reserved.
 * Copyright (c) 2020-2021 Huawei Device Co., Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 * of conditions and the following disclaimer in the documentation and/or other materials
 * provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "osTest.h"
#include "it_los_hwi.h"


static VOID HwiF03(VOID)
{
    TestHwiClear(HWI_NUM_TEST1);
    return;
}

static VOID HwiF02(VOID)
{
    TestHwiClear(HWI_NUM_TEST3);
    return;
}

static VOID HwiF01(VOID)
{
    TestHwiClear(HWI_NUM_TEST);
    g_testCount++;
}

static UINT32 Testcase(VOID)
{
    UINT32 ret;
    UINT32 loop;
    HWI_PRIOR_T hwiPrio = 7;
    HWI_MODE_T mode = 0;
    HWI_ARG_T arg = 0;
    UINT32 intSave1;
    UINT32 intSave2;
    UINT32 intSave3;

    for (loop = 0; loop < HWI_LOOP_NUM; loop++) {
        g_testCount = 0;
        ret = LOS_HwiCreate(HWI_NUM_TEST, hwiPrio, mode, (HWI_PROC_FUNC)HwiF01, arg);
        ICUNIT_ASSERT_EQUAL(ret, LOS_OK, ret);

        ret = LOS_HwiCreate(HWI_NUM_TEST3, hwiPrio, mode, (HWI_PROC_FUNC)HwiF02, arg);
        ICUNIT_GOTO_EQUAL(ret, LOS_OK, ret, EXIT1);

        ret = LOS_HwiCreate(HWI_NUM_TEST1, hwiPrio, mode, (HWI_PROC_FUNC)HwiF03, arg);
        ICUNIT_GOTO_EQUAL(ret, LOS_OK, ret, EXIT2);

        intSave1 = LOS_IntLock();
        intSave2 = LOS_IntLock();
        intSave3 = LOS_IntLock();

        LOS_IntRestore(intSave3);
        ICUNIT_GOTO_EQUAL(g_testCount, 0, g_testCount, EXIT3);

        intSave3 = LOS_IntLock();

        LOS_IntRestore(intSave3);
        ICUNIT_GOTO_EQUAL(g_testCount, 0, g_testCount, EXIT3);

        LOS_IntRestore(intSave2);
        ICUNIT_GOTO_EQUAL(g_testCount, 0, g_testCount, EXIT3);

        LOS_IntRestore(intSave1);
        ICUNIT_GOTO_EQUAL(g_testCount, 0, g_testCount, EXIT3);

        TestHwiTrigger(HWI_NUM_TEST);

        ICUNIT_GOTO_EQUAL(g_testCount, 1, g_testCount, EXIT3);

        TestHwiDelete(HWI_NUM_TEST1);
        TestHwiDelete(HWI_NUM_TEST3);
        TestHwiDelete(HWI_NUM_TEST);
    }
    return LOS_OK;

EXIT3:
    TestHwiDelete(HWI_NUM_TEST1);
    TestHwiDelete(HWI_NUM_TEST3);
    TestHwiDelete(HWI_NUM_TEST);
    return LOS_OK;

EXIT2:
    TestHwiDelete(HWI_NUM_TEST3);
    TestHwiDelete(HWI_NUM_TEST);
    return LOS_OK;

EXIT1:
    TestHwiDelete(HWI_NUM_TEST);
    return LOS_OK;
}

VOID ItLosHwi028(VOID) // IT_Layer_ModuleORFeature_No
{
    TEST_ADD_CASE("ItLosHwi028", Testcase, TEST_LOS, TEST_HWI, TEST_LEVEL3, TEST_PRESSURE);
}
