/********************************** (C) COPYRIGHT *******************************
* File Name          : Udisk_Func_BasicOp.c
* Author             : WCH
* Version            : V1.0.0
* Date               : 2022/11/22
* Description        : USB full-speed port host operation functions.
*********************************************************************************
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* Attention: This software (modified or not) and binary are used for 
* microcontroller manufactured by Nanjing Qinheng Microelectronics.
*******************************************************************************/

/*******************************************************************************/
/* Header File */
#include "Udisk_Operation.h"
uint8_t  *pCodeStr;
/*******************************************************************************/
/* Variable Definition */
__attribute__((aligned(4)))  uint8_t  MY_DATA_BUF[ DISK_BASE_BUF_LEN ];   /* MY_DATA_BUFָⲿRAMĴݻ,Ϊһĳ,ûݻ */
uint8_t  *pCodeStr;

/*********************************************************************
 * @fn      UDisk_USBH_ByteOperation
 *
 * @brief   Demo Function For UDisk File Byte-operation
 *          including Create\Modify\Read\Erase (EXAM1)
 *
 * @return  none
 */
void UDisk_USBH_ByteOperation( void )
{
    uint8_t ret;
    uint8_t i,t;
    uint16_t TotalCount = 0;

    UDisk_USBH_DiskReady( );
    if( (CHRV3DiskStatus >= DISK_MOUNTED)&&( UDisk_Opeation_Flag == 1 ) )
    {
        UDisk_Opeation_Flag = 0;
        printf("CHRV3DiskStatus:%02x\r\n",CHRV3DiskStatus);
        /* ļ */
        strcpy( (char *)mCmdParam.Open.mPathName, "/NEWFILE.C" ); //ýҪļ·ļ/NEWFILE.C
        ret = CHRV3FileOpen( );                                       //ļ
        if ( ret == ERR_MISS_DIR || ret == ERR_MISS_FILE )            //ûҵļ
        {
            //ļʾ
            printf( "Find No File And Create\r\n" );
            strcpy( (char *)mCmdParam.Create.mPathName, "/NEWFILE.C" );  //ļ,ڸĿ¼,ļ
            ret = CHRV3FileCreate( );                                        //½ļ,ļѾɾ½
            mStopIfError( ret );
            printf( "ByteWrite\r\n" );
            //ʵӦждݳȺͶ建ǷڻҪд
            i = sprintf( (char *)Com_Buffer,"Note: \xd\xaֽΪλUļд,ʾܡ\xd\xa");
            for(t=0; t<10; t++)
            {
                mCmdParam.ByteWrite.mByteCount = i;                           //ָдֽ
                mCmdParam.ByteWrite.mByteBuffer = Com_Buffer;                 //ָ򻺳
                ret = CHRV3ByteWrite( );                                      //ֽΪλļд
                mStopIfError( ret );
                printf("ɹд %02X\r\n",(uint16_t)t);
            }
            //ʾ޸ļ
            printf( "Modify\r\n" );
            mCmdParam.Modify.mFileAttr = 0xff;   //: µļ,Ϊ0FFH޸
            mCmdParam.Modify.mFileTime = 0xffff;   //: µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ
            mCmdParam.Modify.mFileDate = MAKE_FILE_DATE( 2015, 5, 18 );  //: µļ: 2015.05.18
            mCmdParam.Modify.mFileSize = 0xffffffff;  // : µļ,ֽΪλдļӦɳرļʱԶ³,Դ˴޸
            i = CHRV3FileModify( );   //޸ĵǰļϢ,޸
            mStopIfError( i );
            printf( "Close\r\n" );
            mCmdParam.Close.mUpdateLen = 1;     //Զļ,ֽΪλдļ,óرļԱԶļ
            i = CHRV3FileClose( );
            mStopIfError( i );

            /* ɾĳļ */
//            printf( "Erase\n" );
//            strcpy( (char *)mCmdParam.Create.mPathName, "/OLD" );  //ɾļ,ڸĿ¼
//            i = CHRV3FileErase( );  //ɾļر
//            if ( i != ERR_SUCCESS ) printf( "Error: %02X\n", (uint16_t)i );  //ʾ
        }
        else
        {
            /* һдļ */
            printf( "ByteWrite\r\n" ); //ϣӵԭļβ,ƶļָ
            mCmdParam.ByteLocate.mByteOffset = 0xffffffff;  //Ƶļβ
            CHRV3ByteLocate( );           //ʵӦждݳȺͶ建ǷڻҪд
            i = sprintf( (char *)Com_Buffer,"Note: \xd\xaֽΪλUļд,ʾܡ\xd\xa"); //ʾ
            for(t=0; t<10; t++)
            {
                mCmdParam.ByteWrite.mByteCount = i;               //ָдֽ
                mCmdParam.ByteWrite.mByteBuffer = Com_Buffer;     // ָ򻺳
                ret = CHRV3ByteWrite( );                          // ֽΪλļд
                mStopIfError( ret );
                printf("ɹд %02X\r\n",(uint16_t)t);
            }

            //ʾ޸ļ
            printf( "Modify\r\n" );
            mCmdParam.Modify.mFileAttr = 0xff;   //: µļ,Ϊ0FFH޸
            mCmdParam.Modify.mFileTime = 0xffff;   //: µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ
            mCmdParam.Modify.mFileDate = MAKE_FILE_DATE( 2015, 5, 18 );  //: µļ: 2015.05.18
            mCmdParam.Modify.mFileSize = 0xffffffff;  // : µļ,ֽΪλдļӦɳرļʱԶ³,Դ˴޸
            i = CHRV3FileModify( );   //޸ĵǰļϢ,޸
            mStopIfError( i );
            printf( "Close\r\n" );
            mCmdParam.Close.mUpdateLen = 1;     //Զļ,ֽΪλдļ,óرļԱԶļ
            i = CHRV3FileClose( );
            mStopIfError( i );

            /* ȡļǰNֽ */
            TotalCount = 60;                                                  //׼ȡܳ100ֽ
            strcpy( (char *)mCmdParam.Open.mPathName, "/NEWFILE.C" );     //ýҪļ·ļ/NEWFILE.C
            CHRV3FileOpen( );                                                 //ļ
            printf( "ǰ%dַ:\r\n",TotalCount );
            while ( TotalCount )
            {
                //ļȽϴ,һζ,ٵCH103ByteReadȡ,ļָԶƶ
                if ( TotalCount > (MAX_PATH_LEN-1) )
                {
                    t = MAX_PATH_LEN-1; // ʣݽ϶,ƵζдĳȲܳ sizeof( mCmdParam.Other.mBuffer )
                }
                else
                {
                    t = TotalCount; //ʣֽ
                }
                mCmdParam.ByteRead.mByteCount = t;                   //ʮֽ
                mCmdParam.ByteRead.mByteBuffer= &Com_Buffer[0];
                ret = CHRV3ByteRead( );                              //ֽΪλȡݿ,ζдĳȲܳMAX_BYTE_IO,ڶεʱŸղŵ
                TotalCount -= mCmdParam.ByteRead.mByteCount;         //,ȥǰʵѾַ
                for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ )
                {
                    printf( "%c", mCmdParam.ByteRead.mByteBuffer[i] ); //ʾַ
                }
                printf( "\r\n" );

                if ( mCmdParam.ByteRead.mByteCount < t ) //ʵʶַҪַ,˵ѾļĽβ
                {
                    printf( "\r\n" );
                    printf( "ļѾ\r\n" );
                    break;
                }
            }
            i = CHRV3FileClose( ); //رļ
            mStopIfError( i );
        }
    }
}

/*********************************************************************
 * @fn      UDisk_USBH_SectorOperation
 *
 * @brief   Demo Function For UDisk File Sector-operation
 *          including Create\Modify\Read\Erase (EXAM6)
 *
 * @return  none
 */
void UDisk_USBH_SectorOperation( void )
{
    uint8_t  ret, SecCount, s;
    uint8_t  i;
    uint16_t tmp;
    uint8_t  tmpbuf[64];

    ret = UDisk_USBH_DiskReady( );
    if( ( ret == DISK_READY )&&( UDisk_Opeation_Flag == 1 ) )
    {
        UDisk_Opeation_Flag = 0;
        /* ѯ */
        printf( "DiskSize\r\n" );
        i = CHRV3DiskQuery( );
        mStopIfError( i );
        printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.Query.mTotalSector * CHRV3vSectorSizeB / 2 ) );  //ʾΪMBΪλ

        /* ȡԭļ */
        printf( "Open\r\n" );
        strcpy( mCmdParam.Open.mPathName, "/NEWFILE.TXT" );//ļ,ļC51Ŀ¼
        s = CHRV3FileOpen( );                       //ļ
        if ( s == ERR_MISS_DIR || s == ERR_MISS_FILE )//ûҵļ
        {
            printf( "ûҵļ\r\n" );
        }
        else                                        //ҵļ߳
        {
            printf( "Query\r\n" );
            i = CHRV3FileQuery( );                  //ѯǰļϢ
            mStopIfError( i );
            printf( "Read\r\n" );
            CHRV3vFileSize = CHRV3vFileSize+(sizeof( MY_DATA_BUF )-1);    //ԭļĳ
            SecCount = CHRV3vFileSize/ sizeof( MY_DATA_BUF )  ;//ļ,ΪдΪλ,ȼCHRV3vSectorSize-1Ϊ˶ļβ1Ĳ
            printf( "Size=%ld, Sec=%d\r\n", CHRV3vFileSize, (uint16_t)SecCount );
            while(SecCount--)
            {
                mCmdParam.Read.mSectorCount = sizeof( MY_DATA_BUF )/512;  //ȡȫ,2ֻȡ2
                mCmdParam.Read.mDataBuffer = &MY_DATA_BUF[0];//ָļݻʼַ
                i = CHRV3FileRead( );                    //ļȡ
                mStopIfError( i );
                if(SecCount == 0) break;
                /*
                for(tmp=0; tmp<sizeof( MY_DATA_BUF ); tmp++)
                {
                printf("%02X ",(uint16_t)MY_DATA_BUF[tmp]);
                }
                printf("\n");
                */
            }
            tmp = (CHRV3vFileSize-(sizeof( MY_DATA_BUF )-1))%sizeof( MY_DATA_BUF );
            if((tmp == 0)&&(CHRV3vFileSize != 0)) tmp = sizeof( MY_DATA_BUF );
            CHRV3vFileSize = CHRV3vFileSize-(sizeof( MY_DATA_BUF )-1);    //ָԭļĳ
            /*
            for(i=0; i<tmp; i++)
            {
              printf("%02X ",(uint16_t)MY_DATA_BUF[i]);
            }
            printf("\n");
            */
            /*
                         ļȽϴ,һζ,ٵCHRV3FileReadȡ,ļָԶƶ
             while ( 1 )
             {
               c = 4;   ÿζȡ4,ԽһζȡԽ
               mCmdParam.Read.mSectorCount = c;   ָȡ
               mCmdParam.Read.mDataBuffer = &MY_DATA_BUF[0];  ָļݻʼַ
               CHRV3FileRead();   ļָԶ 
               if ( mCmdParam.Read.mSectorCount < c ) break;   ʵʶС˵ļѾ
             }
                                               ϣָλÿʼд,ƶļָ
              mCmdParam.Locate.mSectorOffset = 3;  ļǰ3ʼд
              i = CHRV3FileLocate( );
              mCmdParam.Read.mSectorCount = 10;
              mCmdParam.Read.mDataBuffer = &MY_DATA_BUF[0];  ָļݻʼַ
              CHRV3FileRead();   ֱӶȡļĵ(CHRV3vSectorSizeH*256*3)ֽڿʼ,ǰ3
                                               ϣӵԭļβ,ƶļָ
              i = CHRV3FileOpen( );
              mCmdParam.Locate.mSectorOffset = 0xffffffff;  Ƶļβ,Ϊλ,ԭļ3ֽ,CHRV3vSectorSizeHֽڴʼ
              i = CHRV3FileLocate( );
              mCmdParam.Write.mSectorCount = 10;
              mCmdParam.Write.mDataBuffer = &MY_DATA_BUF[0];
              CHRV3FileWrite();   ԭļĺ
                                               ʹCHRV3FileReadжݻʼַ
              mCmdParam.Read.mSectorCount = 2;
              mCmdParam.Read.mDataBuffer = 0x50;  ݷŵ50HʼĻУҪָʼַ
              CHRV3FileRead();   ļжȡ2ָ
                                                ʹCHRV3FileWriteжݻʼַ
              mCmdParam.Wiite.mSectorCount = 2;
              mCmdParam.Write.mDataBuffer = 0x50;  50HʼĻед
              CHRV3FileWrite();   ָед2ļ
            */
            printf( "Close\r\n" );
            i = CHRV3FileClose( );                            //رļ
            mStopIfError( i );
        }
        printf( "Create\r\n" );
        strcpy( mCmdParam.Create.mPathName, "/NEWFILE.TXT" );//ļ,ڸĿ¼,ļ
        s = CHRV3FileCreate( );                               //½ļ,ļѾɾ½ */
        mStopIfError( s );
        printf( "Write\r\n" );
        strcpy( tmpbuf, "0000ABCDEFGHIJKLMNOPQRSTUVWXYZ\xd\xa" );//׼дļ
        for(i=0; i<(DISK_BASE_BUF_LEN/sizeof(tmpbuf)); i++)
        {
            tmp=i*sizeof(tmpbuf);
            strcpy(&MY_DATA_BUF[tmp],tmpbuf);
        }
        for(tmp=0; tmp<sizeof(MY_DATA_BUF); tmp++)
        {
            printf("%02X",(uint16_t)MY_DATA_BUF[tmp]);
        }
        printf("\r\n");
        for(s=0; s<10; s++)
        {
            mCmdParam.Write.mSectorCount = 1;                 //д
            mCmdParam.Write.mDataBuffer = &MY_DATA_BUF[0];    //ָļݻʼַ
            i = CHRV3FileWrite( );                            //ļд
            mStopIfError( i );
            printf("ɹд %02X\r\n",(uint16_t)s);
        }
        /* printf( "Modify\n" );
           mCmdParam.Modify.mFileAttr = 0xff;   : µļ,Ϊ0FFH޸
           mCmdParam.Modify.mFileTime = 0xffff;   : µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ
           mCmdParam.Modify.mFileDate = MAKE_FILE_DATE( 2015, 5, 18 );  : µļ: 2015.05.18
           mCmdParam.Modify.mFileSize = 0xffffffff;   : µļ,ֽΪλдļӦɳرļʱԶ³,Դ˴޸
           i = CHRV3FileModify( );   ޸ĵǰļϢ,޸
           mStopIfError( i );
        */
        printf( "Close\r\n" );
        mCmdParam.Close.mUpdateLen = 1;                        //Զļ,ֽΪλдļ,óرļԱԶļ
        i = CHRV3FileClose( );
        mStopIfError( i );
        /* ɾĳļ */
        /*printf( "Erase\n" );
          strcpy( mCmdParam.Create.mPathName, "/OLD.TXT" );  ɾļ,ڸĿ¼
          i = CHRV3FileErase( );  ɾļر
          if ( i != ERR_SUCCESS ) printf( "Error File not exist: %02X\n", (uint16_t)i );  ʾ
        */
        printf( "Uʾ\r\n" );
    }
}


/*********************************************************************
 * @fn      UDisk_USBH_EnumFiles
 *
 * @brief   Demo Function For Enumerating files in UDisk(EXAM11)
 *
 * @return  none
 */
void UDisk_USBH_EnumFiles( void )
{
    uint8_t  i, s, ret;
    uint16_t j;

    ret = UDisk_USBH_DiskReady( );
    if( ( ret == DISK_READY )&&( UDisk_Opeation_Flag == 1 ) )
    {
        UDisk_Opeation_Flag = 0;
        /* ȡԭļ */
        printf( "Open\r\n" );
        strcpy( mCmdParam.Open.mPathName, "/C51/CHRV3HFT.C" );//ļ,ļC51Ŀ¼
        s = CHRV3FileOpen( );                        //ļ
        /* гļ */
        if ( s == ERR_MISS_DIR )
        {
            printf("ڸļгļ\r\n");  //C51Ŀ¼гĿ¼µļ
            pCodeStr = "/*";
        }
        else
        {
            pCodeStr = "/C51/*";                     //CHRV3HFT.Cļг\C51Ŀ¼µCHRV3ͷļ
        }
        printf( "List file %s\r\n", pCodeStr );
        for ( j = 0; j < 10000; j ++ )               //ǰ10000ļ,ʵû
        {
            strcpy( (char *)mCmdParam.Open.mPathName, pCodeStr );//ļ,*Ϊͨ,ļĿ¼
            i = strlen( mCmdParam.Open.mPathName );
            mCmdParam.Open.mPathName[ i ] = 0xFF;    //ַȽ滻Ϊ,0254,0xFF255˵CHRV3vFileSize
            CHRV3vFileSize = j;                      //ָ/öٵ
            i = CHRV3FileOpen( );                    //ļ,ļкͨ*,Ϊļ
            /* CHRV3FileEnum  CHRV3FileOpen Ψһǵ߷ERR_FOUND_NAMEʱôӦǰ߷ERR_SUCCESS */
            if ( i == ERR_MISS_FILE )
            {
                break;                                //Ҳƥļ,Ѿûƥļ
            }
            if ( i == ERR_FOUND_NAME )
            {
                /* ͨƥļ,ļ· */
                printf( "  match file %04d#: %s\r\n", (unsigned int)j, mCmdParam.Open.mPathName );//ʾźƥļĿ¼
                continue;                             //һƥļ,´ʱŻ1
            }
            else
            {
                /*  */
                mStopIfError( i );
                break;
            }
        }
        printf( "Close\r\n" );
        CHRV3FileClose( );                            //رļ
        printf( "Uʾ\r\n" );
    }
}
