@ECHO OFF
REM            Deletes all Files of the ASEM-51 V1.3 Package
REM            =============================================
REM
REM            usage:      KILLASEM path

REM Parse command line parameters:
REM ------------------------------
IF (%1)==() GOTO DEFAULT
IF NOT (%2)==() GOTO TOOMANY
IF EXIST %1ASEM.EXE GOTO DEFAULT
IF NOT EXIST %1\ASEM.EXE GOTO NOTFOUND
SET ASEMLOC=%1\
GOTO KILLALL
:DEFAULT
SET ASEMLOC=%1
:KILLALL
IF NOT EXIST %ASEMLOC%ASEM.EXE GOTO NOTFOUND

REM Delete installed ASEM-51 files:
REM -------------------------------

REM Assembler-related files:
IF EXIST %ASEMLOC%ASEM_51.DOC DEL %ASEMLOC%ASEM_51.DOC
IF EXIST %ASEMLOC%ASEM.EXE DEL %ASEMLOC%ASEM.EXE
IF EXIST %ASEMLOC%ASEM.PIF DEL %ASEMLOC%ASEM.PIF
IF EXIST %ASEMLOC%ASEM.ICO DEL %ASEMLOC%ASEM.ICO
IF EXIST %ASEMLOC%ASEMX.EXE DEL %ASEMLOC%ASEMX.EXE
IF EXIST %ASEMLOC%ASEMX.PIF DEL %ASEMLOC%ASEMX.PIF
IF EXIST %ASEMLOC%ASEMX.ICO DEL %ASEMLOC%ASEMX.ICO
IF EXIST %ASEMLOC%DPMI16BI.OVL DEL %ASEMLOC%DPMI16BI.OVL
IF EXIST %ASEMLOC%RTM.EXE DEL %ASEMLOC%RTM.EXE
IF EXIST %ASEMLOC%ASEM32.BAT DEL %ASEMLOC%ASEM32.BAT
IF EXIST %ASEMLOC%ASEMW.EXE DEL %ASEMLOC%ASEMW.EXE
IF EXIST %ASEMLOC%ASEM2MSG.EXE DEL %ASEMLOC%ASEM2MSG.EXE
IF EXIST %ASEMLOC%ASEM2MSG.PAS DEL %ASEMLOC%ASEM2MSG.PAS
IF EXIST %ASEMLOC%HEXBIN.EXE DEL %ASEMLOC%HEXBIN.EXE
IF EXIST %ASEMLOC%HEXBINW.EXE DEL %ASEMLOC%HEXBINW.EXE
IF EXIST %ASEMLOC%DEMO.* DEL %ASEMLOC%DEMO.*

REM Include files:
IF EXIST %ASEMLOC%*.MCU DEL %ASEMLOC%*.MCU
IF NOT EXIST %ASEMLOC%MCU\*.MCU GOTO NOMCUDIR
DEL %ASEMLOC%MCU\*.MCU
RMDIR %ASEMLOC%MCU
:NOMCUDIR

REM HTML documentation files:
IF EXIST %ASEMLOC%*.HTM DEL %ASEMLOC%*.HTM
IF EXIST %ASEMLOC%*.GIF DEL %ASEMLOC%*.GIF
IF EXIST %ASEMLOC%*.JPG DEL %ASEMLOC%*.JPG
IF NOT EXIST %ASEMLOC%HTML\*.HTM GOTO NOHTMLDIR
DEL %ASEMLOC%HTML\*.HTM
IF EXIST %ASEMLOC%HTML\*.GIF DEL %ASEMLOC%HTML\*.GIF
IF EXIST %ASEMLOC%HTML\*.JPG DEL %ASEMLOC%HTML\*.JPG
RMDIR %ASEMLOC%HTML
:NOHTMLDIR

REM BOOT-51 files:
IF EXIST %ASEMLOC%BOOT51.* DEL %ASEMLOC%BOOT51.*
IF EXIST %ASEMLOC%CUSTOMIZ.EXE DEL %ASEMLOC%CUSTOMIZ.EXE
IF EXIST %ASEMLOC%BOOT.BAT DEL %ASEMLOC%BOOT.BAT
IF EXIST %ASEMLOC%UPLOAD.BAT DEL %ASEMLOC%UPLOAD.BAT
IF EXIST %ASEMLOC%RESET51.EXE DEL %ASEMLOC%RESET51.EXE
IF EXIST %ASEMLOC%SLEEP.EXE DEL %ASEMLOC%SLEEP.EXE
IF EXIST %ASEMLOC%COMPORT.EXE DEL %ASEMLOC%COMPORT.EXE
IF EXIST %ASEMLOC%BLINK.* DEL %ASEMLOC%BLINK.*

REM General files:
IF EXIST %ASEMLOC%LICENSE.DOC DEL %ASEMLOC%LICENSE.DOC
IF EXIST %ASEMLOC%RELEASE.130 DEL %ASEMLOC%RELEASE.130
IF EXIST %ASEMLOC%SUPPORT.DOC DEL %ASEMLOC%SUPPORT.DOC
IF EXIST %ASEMLOC%FILE_ID.DIZ DEL %ASEMLOC%FILE_ID.DIZ
IF EXIST %ASEMLOC%INSTALL.BAT DEL %ASEMLOC%INSTALL.BAT
IF EXIST %ASEMLOC%README.1ST DEL %ASEMLOC%README.1ST

REM Legacy files from previous ASEM-51 versions:
IF EXIST %ASEMLOC%RESET.EXE DEL %ASEMLOC%RESET.EXE
IF EXIST %ASEMLOC%LOAD.BAT DEL %ASEMLOC%LOAD.BAT
IF EXIST %ASEMLOC%RELEASE.120 DEL %ASEMLOC%RELEASE.120
IF EXIST %ASEMLOC%UPDATES.DOC DEL %ASEMLOC%UPDATES.DOC
IF EXIST %ASEMLOC%RELEASE.110 DEL %ASEMLOC%RELEASE.110

REM And after all, this batch file, too:
IF EXIST %ASEMLOC%KILLASEM.BAT DEL %ASEMLOC%KILLASEM.BAT

SET ASEMLOC=
GOTO FINISHED

REM Error messages:
REM ---------------

:NOTFOUND
ECHO .
ECHO @@@@@ file ASEM.EXE not found @@@@@
GOTO ONLINEHELP

:TOOMANY
ECHO .
ECHO @@@@@ too many parameters: %2 @@@@@
GOTO ONLINEHELP

:ONLINEHELP
ECHO .
ECHO usage:     %0 path
ECHO .

:FINISHED
